function PlotImg(handles)
% The last step in the image plotting
% Here the axes and the colorbar are defined as well as the contours of the
% particle.

%% Get Handles

Data      = get(handles.CAxisMax,'UserData');
Contours  = get(handles.Contours,'Value');
Image     = Data{1};
B         = Data{2};
AxisX     = Data{3};
AxisY     = Data{4};
AxPosMax  = round(get(handles.CAxisMax,'Value'),3);
AxPosMin  = round(get(handles.CAxisMin,'Value'),3);
cmax      = max(max(Image));
cmin      = min(min(Image));
CMax      = cmax *AxPosMax;
CMin      = cmin + (cmax-cmin)*AxPosMin;
XMax      = AxisX(end);
YMax      = AxisY(1);

imagesc(AxisX,AxisY,Image,'Parent',handles.Axis);
colormap(handles.Axis,hot(255));
colorbar(handles.Axis);
xlim(handles.Axis,[-XMax,XMax]);
ylim(handles.Axis,[-YMax,YMax]);
caxis(handles.Axis,[CMin,CMax]);
xlabel(handles.Axis, 'x [nm]' );
ylabel(handles.Axis, 'y [nm]' );
axis(handles.Axis,'equal');
set(handles.Axis,'YDir','normal')

if Contours==1
    hold(handles.Axis, 'on');
    for k = 1:length(B)
        x = B{k}(:,2);
        y = B{k}(:,1);
        plot(handles.Axis,x, y, 'b', 'LineWidth', 2);
        xlim(handles.Axis,[-XMax,XMax]);
        ylim(handles.Axis,[-YMax,YMax]);
    end
    hold(handles.Axis,'off');
end

clearvars all